#include <amxmodx>
#include <umitem>
#include <engine>
#include <fun>

new PLUGIN_NAME[] 	= "UM Item: Crowbar"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.0"

new bool:g_Crowbar[33]
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Crowbar", "1 hit 1 kill knife", 3000)
	register_event("Damage", "Event_Damage", "be", "2!0")
	register_event("CurWeapon", "Event_CurWeapon", "be", "1=1")
}

public client_connect(id) {
	g_Crowbar[id] = false
}

public Enable_Item(id) {
	g_Crowbar[id] = true
}

public Disable_Item(id) {
	g_Crowbar[id] = false
}

public Event_CurWeapon(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(!g_Crowbar[id]) {
		return PLUGIN_CONTINUE
	}
	
	new Weapon_ID = read_data(2)
	if(Weapon_ID == CSW_KNIFE) 
	{
		entity_set_string(id, EV_SZ_viewmodel, "models/v_crowbar.mdl")
		entity_set_string(id, EV_SZ_weaponmodel, "models/p_crowbar.mdl")
	}
	return PLUGIN_CONTINUE
}

public Event_Damage(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	new iDamage = read_data(2)
	new Bodypart, Weapon, Enemy = get_user_attacker(id, Weapon, Bodypart)
	
	if(!is_user_connected(Enemy) || !is_user_alive(Enemy)) {
		return PLUGIN_CONTINUE
	}
	
	if(!g_Crowbar[Enemy]) {
		return PLUGIN_CONTINUE
	}
	
	if(Weapon == CSW_KNIFE)
	{
		new iHealth = get_user_health(id)
		new newDamage = floatround((float(iHealth) - float(iDamage)))
		if(newDamage < 1) 
		{
			set_msg_block(get_user_msgid("DeathMsg"), BLOCK_ONCE)
			message_begin(MSG_ALL, get_user_msgid("DeathMsg"), {0, 0, 0}, 0)
			write_byte(Enemy)
			write_byte(id)
			write_byte(0)			
			write_string("knife")
			message_end()
		}
		set_user_health(id, newDamage)
	}
	return PLUGIN_CONTINUE
}

public plugin_precache()
{
	precache_model("models/v_crowbar.mdl")
	precache_model("models/p_crowbar.mdl")
}
